var ReinventedColorWheel = ( function () {
	'use strict';
	var e = function ( e ) {
			var t = e[ 0 ],
				n = e[ 1 ] / 100,
				h = e[ 2 ] / 100;
			return 0 === h
				? [ 0, 0, 0 ]
				: [
						t,
						( ( 2 * ( n *= ( h *= 2 ) <= 1 ? h : 2 - h ) ) /
							( h + n ) ) *
							100,
						( ( h + n ) / 2 ) * 100,
				  ];
		},
		t = function ( e ) {
			var t,
				n,
				h = e[ 0 ],
				i = e[ 1 ] / 100,
				r = e[ 2 ] / 100;
			return (
				( t = i * r ),
				[
					h,
					100 *
						( t =
							( t /= ( n = ( 2 - i ) * r ) <= 1 ? n : 2 - n ) ||
							0 ),
					100 * ( n /= 2 ),
				]
			);
		};
	function n( e ) {
		var t = e[ 0 ],
			n = e[ 1 ],
			h = e[ 2 ],
			i = Math.max( t, n, h ),
			r = i - Math.min( t, n, h ),
			s =
				r &&
				60 *
					( i === t
						? ( ( n - h ) / r ) % 6
						: i === n
						? ( h - t ) / r + 2
						: ( t - n ) / r + 4 );
		return [ s < 0 ? s + 360 : s, i && ( 100 * r ) / i, ( 100 * i ) / 255 ];
	}
	function h( e ) {
		var t = e[ 0 ] / 60,
			n = e[ 1 ] / 100,
			h = e[ 2 ] / 100,
			i = h * n,
			r = h - i,
			s =
				( 255 * ( i * ( 1 - Math.abs( ( t % 2 ) - 1 ) ) + r ) + 0.5 ) |
				0,
			a = ( 255 * ( i + r ) + 0.5 ) | 0,
			o = ( 255 * r + 0.5 ) | 0,
			l = 0 | t;
		return 1 === l
			? [ s, a, o ]
			: 2 === l
			? [ o, a, s ]
			: 3 === l
			? [ o, s, a ]
			: 4 === l
			? [ s, o, a ]
			: 5 === l
			? [ a, o, s ]
			: [ a, s, o ];
	}
	var i = function ( e, t, n ) {
		return Math.min( Math.max( e, t ), n );
	};
	function r( e ) {
		var t = Math.round( i( e, 0, 255 ) ).toString( 16 );
		return 1 == t.length ? '0' + t : t;
	}
	var s = function ( e ) {
			var t = 4 === e.length ? r( 255 * e[ 3 ] ) : '';
			return '#' + r( e[ 0 ] ) + r( e[ 1 ] ) + r( e[ 2 ] ) + t;
		},
		a = function ( e ) {
			( 4 !== e.length && 5 !== e.length ) ||
				( e = ( function ( e ) {
					for ( var t = '#', n = 1; n < e.length; n++ ) {
						var h = e.charAt( n );
						t += h + h;
					}
					return t;
				} )( e ) );
			var t = [
				parseInt( e.substring( 1, 3 ), 16 ),
				parseInt( e.substring( 3, 5 ), 16 ),
				parseInt( e.substring( 5, 7 ), 16 ),
			];
			if ( 9 === e.length ) {
				var n = parseFloat(
					( parseInt( e.substring( 7, 9 ), 16 ) / 255 ).toFixed( 2 )
				);
				t.push( n );
			}
			return t;
		};
	function o( e, t ) {
		return e
			? [
					v( e[ 0 ] ) ? u( e[ 0 ] ) : t[ 0 ],
					v( e[ 1 ] ) ? c( e[ 1 ] ) : t[ 1 ],
					v( e[ 2 ] ) ? c( e[ 2 ] ) : t[ 2 ],
			  ]
			: t;
	}
	function l( e ) {
		return [ u( e[ 0 ] ), c( e[ 1 ] ), c( e[ 2 ] ) ];
	}
	function u( e ) {
		var t = Math.round( ( e % 360 ) * 10 ) / 10;
		return t < 0 ? t + 360 : t;
	}
	function c( e ) {
		return e < 0 ? 0 : e > 100 ? 100 : ( ( 10 * e + 0.5 ) | 0 ) / 10;
	}
	function v( e ) {
		return 'number' == typeof e && isFinite( e );
	}
	var d = 'undefined' != typeof globalThis ? globalThis : self,
		p =
			'PointerEvent' in d
				? function ( e, t, n ) {
						e.addEventListener( 'pointerdown', function ( e ) {
							0 === e.button &&
								! 1 !== t( e ) &&
								this.setPointerCapture( e.pointerId );
						} ),
							e.addEventListener( 'pointermove', function ( e ) {
								this.hasPointerCapture( e.pointerId ) && n( e );
							} );
				  }
				: 'ontouchend' in d
				? function ( e, t, n ) {
						var h = ! 1;
						e.addEventListener( 'touchstart', function ( e ) {
							1 === e.touches.length &&
								! 1 !== t( e.touches[ 0 ] ) &&
								( ( h = ! 0 ), e.preventDefault() );
						} ),
							e.addEventListener( 'touchmove', function ( e ) {
								h &&
									1 === e.touches.length &&
									( e.preventDefault(), n( e.touches[ 0 ] ) );
							} );
				  }
				: function ( e, t, n ) {
						var h = function ( e ) {
								n( e );
							},
							i = function () {
								removeEventListener( 'mouseup', i ),
									removeEventListener( 'mousemove', h );
							};
						e.addEventListener( 'mousedown', function ( e ) {
							0 === e.button &&
								! 1 !== t( e ) &&
								( addEventListener( 'mousemove', h ),
								addEventListener( 'mouseup', i ) );
						} );
				  },
		f = {
			hsv: [ 0, 100, 100 ],
			hsl: [ 0, 100, 50 ],
			wheelDiameter: 200,
			wheelThickness: 20,
			handleDiameter: 16,
			wheelReflectsSaturation: ! 0,
			onChange: function () {},
		},
		m = d.DOMMatrix || d.WebKitCSSMatrix || d.MSCSSMatrix,
		g = function ( e ) {
			for ( var t = [ e ]; ( e = e.parentElement );  ) t.push( e );
			for ( var n = new m(), h = t.length - 1; h >= 0; h-- ) {
				var i = getComputedStyle( t[ h ] ),
					r = i.transform;
				if ( r && 'none' !== r ) {
					var s = i.transformOrigin.split( ' ' ).map( parseFloat );
					n = n
						.translate( s[ 0 ], s[ 1 ] )
						.multiply( new m( r ) )
						.translate( -s[ 0 ], -s[ 1 ] );
				}
			}
			return n.inverse();
		},
		w = function ( e, t ) {
			return (
				e === t ||
				( e[ 0 ] === t[ 0 ] && e[ 1 ] === t[ 1 ] && e[ 2 ] === t[ 2 ] )
			);
		},
		_ = ( function () {
			function i( e ) {
				var t = this;
				( this.options = e ),
					( this.wheelDiameter =
						this.options.wheelDiameter || f.wheelDiameter ),
					( this.wheelThickness =
						this.options.wheelThickness || f.wheelThickness ),
					( this.handleDiameter =
						this.options.handleDiameter || f.handleDiameter ),
					( this.onChange = this.options.onChange || f.onChange ),
					( this.wheelReflectsSaturation =
						void 0 !== this.options.wheelReflectsSaturation
							? this.options.wheelReflectsSaturation
							: f.wheelReflectsSaturation ),
					( this.rootElement = this.options.appendTo.appendChild(
						b( 'div', 'reinvented-color-wheel' )
					) ),
					( this.hueWheelElement = this.rootElement.appendChild(
						b( 'canvas', 'reinvented-color-wheel--hue-wheel' )
					) ),
					( this.hueWheelContext =
						this.hueWheelElement.getContext( '2d' ) ),
					( this.hueHandleElement = this.rootElement.appendChild(
						b( 'div', 'reinvented-color-wheel--hue-handle' )
					) ),
					( this.svSpaceElement = this.rootElement.appendChild(
						b( 'canvas', 'reinvented-color-wheel--sv-space' )
					) ),
					( this.svSpaceContext =
						this.svSpaceElement.getContext( '2d' ) ),
					( this.svHandleElement = this.rootElement.appendChild(
						b( 'div', 'reinvented-color-wheel--sv-handle' )
					) ),
					( this._redrawHueWheel = function () {
						t._redrawHueWheelRequested = ! 1;
						var e = t.wheelDiameter,
							n = e / 2,
							h = n - t.wheelThickness / 2,
							i = Math.PI / 180,
							r = t.wheelReflectsSaturation
								? ','
										.concat( t._hsl[ 1 ], '%,' )
										.concat( t._hsl[ 2 ], '%)' )
								: ',100%,50%)',
							s = t.hueWheelContext;
						s.clearRect( 0, 0, e, e ),
							( s.lineWidth = t.wheelThickness );
						for ( var a = 0; a < 360; a++ )
							s.beginPath(),
								s.arc(
									n,
									n,
									h,
									( a - 90.7 ) * i,
									( a - 89.3 ) * i
								),
								( s.strokeStyle = 'hsl(' + a + r ),
								s.stroke();
					} ),
					( this.hueWheelContext.imageSmoothingEnabled = ! 1 ),
					( this.svSpaceContext.imageSmoothingEnabled = ! 1 ),
					( this._hsv = o(
						e.hsv
							? e.hsv
							: e.hsl
							? i.hsl2hsv( e.hsl )
							: e.rgb
							? i.rgb2hsv( e.rgb )
							: e.hex
							? i.rgb2hsv( i.hex2rgb( e.hex ) )
							: void 0,
						f.hsv
					) ),
					( this._hsl = l( i.hsv2hsl( this._hsv ) ) ),
					( this._rgb = i.hsv2rgb( this._hsv ) ),
					( this._hex = i.rgb2hex( this._rgb ) );
				var n = function ( e, n ) {
						var h = t._inverseTransform.multiply(
							new m(
								'matrix(1,0,0,1,'
									.concat( e, ',' )
									.concat( n, ')' )
							)
						);
						return { x: h.e, y: h.f };
					},
					h = function ( e ) {
						t._inverseTransform = g( e );
						var h = e.getBoundingClientRect();
						t._center = n(
							h.left + h.width / 2,
							h.top + h.height / 2
						);
					},
					r = function ( e ) {
						var h = n( e.clientX, e.clientY ),
							i = h.x - t._center.x,
							r = h.y - t._center.y,
							s = Math.atan2( r, i );
						t.hsv = [
							( 180 * s ) / Math.PI + 90,
							t.hsv[ 1 ],
							t.hsv[ 2 ],
						];
					},
					s = function ( e ) {
						var h = n( e.clientX, e.clientY ),
							i = 100 / t.svSpaceElement.width,
							r = ( h.x - t._center.x ) * i + 50,
							s = ( t._center.y - h.y ) * i + 50;
						t.hsv = [ t._hsv[ 0 ], r, s ];
					},
					a = function ( e ) {
						h( t.svSpaceElement ), s( e );
					};
				p(
					this.hueWheelElement,
					function ( e ) {
						h( t.hueWheelElement );
						var i = n( e.clientX, e.clientY ),
							s = i.x - t._center.x,
							a = i.y - t._center.y,
							o = t.wheelDiameter / 2 - t.wheelThickness;
						if ( s * s + a * a < o * o ) return ! 1;
						r( e );
					},
					r
				),
					p( this.svSpaceElement, a, s ),
					p( this.svHandleElement, a, s ),
					this.redraw();
			}
			return (
				Object.defineProperty( i.prototype, 'hsv', {
					get: function () {
						return this._hsv;
					},
					set: function ( e ) {
						w( this._hsv, e ) || this._setHSV( e );
					},
					enumerable: ! 1,
					configurable: ! 0,
				} ),
				Object.defineProperty( i.prototype, 'hsl', {
					get: function () {
						return this._hsl;
					},
					set: function ( e ) {
						w( this._hsl, e ) || this._setHSV( i.hsl2hsv( e ) );
					},
					enumerable: ! 1,
					configurable: ! 0,
				} ),
				Object.defineProperty( i.prototype, 'rgb', {
					get: function () {
						return this._rgb;
					},
					set: function ( e ) {
						w( this._rgb, e ) || this._setHSV( i.rgb2hsv( e ) );
					},
					enumerable: ! 1,
					configurable: ! 0,
				} ),
				Object.defineProperty( i.prototype, 'hex', {
					get: function () {
						return this._hex;
					},
					set: function ( e ) {
						this._hex !== e && ( this.rgb = i.hex2rgb( e ) );
					},
					enumerable: ! 1,
					configurable: ! 0,
				} ),
				( i.prototype.setHSV = function () {
					this.hsv = arguments;
				} ),
				( i.prototype.setHSL = function () {
					this.hsl = arguments;
				} ),
				( i.prototype.redraw = function () {
					( this.hueWheelElement.width = this.hueWheelElement.height =
						this.wheelDiameter ),
						( this.svSpaceElement.width =
							this.svSpaceElement.height =
								( this.wheelDiameter -
									2 * this.wheelThickness ) *
								Math.SQRT1_2 );
					var e = this.hueHandleElement.style,
						t = this.svHandleElement.style;
					( e.width =
						e.height =
						t.width =
						t.height =
							''.concat( this.handleDiameter, 'px' ) ),
						( e.marginLeft =
							e.marginTop =
							t.marginLeft =
							t.marginTop =
								''.concat( -this.handleDiameter / 2, 'px' ) ),
						this._redrawHueWheel(),
						this._redrawHueHandle(),
						this._redrawSvSpace(),
						this._redrawSvHandle();
				} ),
				( i.prototype._setHSV = function ( e ) {
					var t = this._hsv,
						n = ( this._hsv = o( e, t ) ),
						h = t[ 0 ] - n[ 0 ],
						r = t[ 1 ] - n[ 1 ] || t[ 2 ] - n[ 2 ];
					h &&
						( ( this._hsl = [
							n[ 0 ],
							this._hsl[ 1 ],
							this._hsl[ 2 ],
						] ),
						this._redrawHueHandle(),
						this._updateSvBackground() ),
						r &&
							( ( this._hsl = l( i.hsv2hsl( n ) ) ),
							this._redrawSvHandle(),
							this.wheelReflectsSaturation &&
								! this._redrawHueWheelRequested &&
								( requestAnimationFrame( this._redrawHueWheel ),
								( this._redrawHueWheelRequested = ! 0 ) ) ),
						( h || r ) &&
							( ( this._rgb = i.hsv2rgb( n ) ),
							( this._hex = i.rgb2hex( this._rgb ) ),
							this.onChange( this ) );
				} ),
				( i.prototype._redrawSvSpace = function () {
					this._updateSvBackground();
					var e = this.svSpaceElement.width,
						t = this.svSpaceContext,
						n = t.createLinearGradient( 0, 0, e, 0 ),
						h = t.createLinearGradient( 0, 0, 0, e );
					n.addColorStop( 0, 'rgba(255,255,255,1)' ),
						n.addColorStop( 1, 'rgba(255,255,255,0)' ),
						h.addColorStop( 0, 'rgba(0,0,0,0)' ),
						h.addColorStop( 1, 'rgba(0,0,0,1)' ),
						( t.fillStyle = n ),
						t.fillRect( 0, 0, e, e ),
						( t.fillStyle = h ),
						t.fillRect( 0, 0, e, e );
				} ),
				( i.prototype._updateSvBackground = function () {
					this.svSpaceElement.style.backgroundColor = 'hsl('.concat(
						this._hsv[ 0 ],
						',100%,50%)'
					);
				} ),
				( i.prototype._redrawHueHandle = function () {
					var e = this.wheelDiameter / 2,
						t = e - this.wheelThickness / 2,
						n = ( ( this._hsv[ 0 ] - 90 ) * Math.PI ) / 180,
						h = this.hueHandleElement.style;
					( h.left = ''.concat( t * Math.cos( n ) + e, 'px' ) ),
						( h.top = ''.concat( t * Math.sin( n ) + e, 'px' ) );
				} ),
				( i.prototype._redrawSvHandle = function () {
					var e = this.svSpaceElement.width,
						t = this.svHandleElement.style,
						n = ( this.wheelDiameter - e ) / 2,
						h = this._hsv;
					( t.left = ''.concat( n + ( e * h[ 1 ] ) / 100, 'px' ) ),
						( t.top = ''.concat(
							n + e * ( 1 - h[ 2 ] / 100 ),
							'px'
						) );
				} ),
				( i.default = i ),
				( i.defaultOptions = f ),
				( i.hsv2hsl = t ),
				( i.hsl2hsv = e ),
				( i.hsv2rgb = h ),
				( i.rgb2hsv = n ),
				( i.rgb2hex = s ),
				( i.hex2rgb = a ),
				i
			);
		} )();
	function b( e, t ) {
		var n = document.createElement( e );
		return ( n.className = t ), n;
	}
	return _;
} )();
