'use strict';
document.addEventListener( 'DOMContentLoaded', function () {
	//Make the DIV element draggagle:
	const dragElementsIDs = [ 'token-color-picker', 'token-plain-picker' ];
	dragElementsIDs.forEach( ( el ) => {
		dragElement( document.getElementById( el ) );
	} );

	function dragElement( elmnt ) {
		var pos1 = 0,
			pos2 = 0,
			pos3 = 0,
			pos4 = 0,
			left = 0,
			top = 0;

		if ( document.getElementById( elmnt.id + '-header' ) ) {
			/* if present, the header is where you move the DIV from:*/
			document.getElementById( elmnt.id + '-header' ).onmousedown =
				dragMouseDown;
		} else {
			/* otherwise, move the DIV from anywhere inside the DIV:*/
			elmnt.onmousedown = dragMouseDown;
		}

		function dragMouseDown( e ) {
			e = e || window.event;
			e.preventDefault();
			// get the mouse cursor position at startup:
			pos3 = e.clientX;
			pos4 = e.clientY;
			document.onmouseup = closeDragElement;
			// call a function whenever the cursor moves:
			document.onmousemove = elementDrag;
		}

		function elementDrag( e ) {
			e = e || window.event;
			e.preventDefault();
			// calculate the new cursor position:
			pos1 = pos3 - e.clientX;
			pos2 = pos4 - e.clientY;
			pos3 = e.clientX;
			pos4 = e.clientY;
			left = elmnt.offsetLeft - pos1;
			top = elmnt.offsetTop - pos2;
			if ( left < 0 ) left = 0;
			if ( top < 0 ) top = 0;
			// set the element's new position:
			elmnt.style.top = top + 'px';
			elmnt.style.left = left + 'px';
			elmnt.style.position = 'absolute';
		}

		function closeDragElement() {
			/* stop moving when mouse button is released:*/
			document.onmouseup = null;
			document.onmousemove = null;
		}
	}
} );
