<?php
if (!defined('WPINC')) die;
/* AJAX Security things */
/*1: Authorization checks via current_user_can() :: https://patchstack.com/articles/patchstack-weekly-week-19-secure-ajax-endpoints/ */
/*2: Nonce check to prevent CSRF :: https://patchstack.com/articles/patchstack-weekly-week-03-wordpress-vulnerabilities-cross-site-request-forgery/*/
function headspin_user_permission_allowed(){
	
    /*
    if(!function_exists('wp_get_current_user')) {
		include(ABSPATH . "wp-includes/pluggable.php"); 
	}
	*/
	if(current_user_can('administrator')) {
	return true;
	}
	else{
		return false;
	}
}
function headspin_ajax_permission_allowed($nonce, $nonce_type){
    if( isset($_POST[$nonce])
    && wp_verify_nonce($_POST[$nonce], $nonce_type)
    && current_user_can('administrator') ) {
        return true;
    } else {
	if(! wp_verify_nonce($_POST[$nonce], $nonce_type)) wp_send_json_error( 'invalid nonce' );
    return false;
    }
}
/*
if( isset($_POST['refund_nonce'])
&& wp_verify_nonce($_POST['refund_nonce'], 'refund-order')
&& current_user_can('refund_orders']) ) {
# Then, do stuff
} else {
die('Unauthorized Action');
}
*/

/* Multisite */
// is_multisite() => check if it's multisite
// is_super_admin() => an be used to check if the currently logged-in user is a Network Administrator on the network.
// is_network_admin()  => is the multisite equivalent of the is_admin function and determines whether the current request is for the network administrative interface.

//https://developer.wordpress.org/plugins/settings/options-api/

/*Helper multisite functions */

/* Options API wrapper, multisite support */
function headspin_per_site_update_option($key, $value){
	if ( is_multisite() ) {
		$blog_id = get_current_blog_id();
		update_blog_option($blog_id, $key, $value);
	 }
	else {
		update_option( $key, $value, false);
	}
}
function headspin_per_site_get_option($key){
	if ( is_multisite() ) {
		$blog_id = get_current_blog_id();
		return get_blog_option($blog_id, $key, 'not-exist');
	 }
	else {
		return get_option($key, 'not-exist');
	}
}
function headspin_per_site_add_option($key, $value){
	if ( is_multisite() ) {
		$blog_id = get_current_blog_id();
		return add_blog_option($blog_id, $key, $value);
	 }
	else {
		return add_option($key, $value, '', false);
	}
}
function headspin_per_site_delete_option($key){
	if ( is_multisite() ) {
		$blog_id = get_current_blog_id();
		return delete_blog_option($blog_id, $key);
	 }
	else {
		return delete_option( $key);
	}
}
/* Perfomance improvement if needed (looping multisites blogs)=> check https://rudrastyh.com/tag/performance */
/* Used to clear all files generated by Headspin */
function headspin_clear_all_options($key){
	if ( is_multisite() ) {
		if ( function_exists( 'get_sites' ) && class_exists( 'WP_Site_Query' ) ) {
			$sites = get_sites();
			foreach ( $sites as $site ) {
				$blog_id = $site->blog_id;
				switch_to_blog($blog_id);
				delete_blog_option($blog_id, $key); 
				restore_current_blog();
			}
			return;
		}
	}
	else{
		headspin_per_site_delete_option($key);
	}
}
/* Used to clear all files generated by Headspin */
function headspin_clear_all_css_content_folders(){
	if ( is_multisite() ) {
		if ( function_exists( 'get_sites' ) && class_exists( 'WP_Site_Query' ) ) {
			$sites = get_sites();
			foreach ( $sites as $site ) {
				$blog_id = $site->blog_id;
				switch_to_blog($blog_id);
				
				if (!class_exists('\WP_Filesystem')) {
					require_once(ABSPATH . 'wp-admin/includes/file.php');
				}
				WP_Filesystem();
				global $wp_filesystem;
				$upload_dir = wp_upload_dir(); 
				$dir = trailingslashit($upload_dir['basedir']) . HSF_CSS_DIR_ASSETS; // 
				if ($wp_filesystem->is_dir($dir)) {
					$wp_filesystem->rmdir($dir);
				}
				$wp_filesystem->put_contents($dir . HSF_CSS_DIR_FILENAME, $css, 0644); 
				restore_current_blog();
				
			}
			return wp_cache_flush();
		}
		
		
	 }
	else {
		if (!class_exists('\WP_Filesystem')) {
			require_once(ABSPATH . 'wp-admin/includes/file.php');
		}
		// Initialize the WordPress filesystem
		WP_Filesystem();
		global $wp_filesystem;
	
		$upload_dir = wp_upload_dir(); // Grab uploads folder array
		$dir = trailingslashit($upload_dir['basedir']) . HSF_CSS_DIR_ASSETS; // Set storage directory path
	
		//if folder does not exist, make it 
		if ($wp_filesystem->is_dir($dir)) {
			$wp_filesystem->rmdir($dir,true);
		}
		wp_cache_flush();
	}
}
/* WP contents folder API wrapper  */
// https://developer.wordpress.org/reference/functions/switch_to_blog/
function headspin_per_site_css_content_folder($css){

	if ( is_multisite() ) {
		//we need to switch context to for workin in multisite
		switch_to_blog( get_current_blog_id() );

		if (!class_exists('\WP_Filesystem')) {
			require_once(ABSPATH . 'wp-admin/includes/file.php');
		}
		// Initialize the WordPress filesystem
		WP_Filesystem();
		global $wp_filesystem;
		$upload_dir = wp_upload_dir(); 
		$dir = trailingslashit($upload_dir['basedir']) . HSF_CSS_DIR_ASSETS; // 
		if (!$wp_filesystem->is_dir($dir)) {
			$wp_filesystem->mkdir($dir);
		}
		$wp_filesystem->put_contents($dir . HSF_CSS_DIR_FILENAME, $css, 0644); 
		restore_current_blog();
		wp_cache_flush();
	 }
	else {
		if (!class_exists('\WP_Filesystem')) {
			require_once(ABSPATH . 'wp-admin/includes/file.php');
		}
		// Initialize the WordPress filesystem
		WP_Filesystem();
		global $wp_filesystem;
	
		$upload_dir = wp_upload_dir(); // Grab uploads folder array
		$dir = trailingslashit($upload_dir['basedir']) . HSF_CSS_DIR_ASSETS; // Set storage directory path
	
		//if folder does not exist, make it 
		if (!$wp_filesystem->is_dir($dir)) {
			$wp_filesystem->mkdir($dir);
		}
	
		$wp_filesystem->put_contents($dir . HSF_CSS_DIR_FILENAME, $css, 0644);
		wp_cache_flush();
	}

}